function MqCheckInOutExt(iFldID_Status, iFldID_AllocatedToPerson, iFldID_RequestedUntil, iFldID_CurrentLocation, 
							iFldID_SendForRepair, iFldID_StorageLocation, iFldID_CheckIn, iFldID_CheckInAsset, iFldID_CheckOutAsset, 
							iFldID_ToBeDeleted, oCenMn)
{			
	var m_lngExchangeToID=0;
	var m_strExchangeTo="";
	var m_strExchangeFrom="";
	var m_oCenMn=oCenMn;
	var m_oFldVals=g_VWS.RecordMgr().CurrentRecord().FldVals;
	var STATUS_ASSIGNED="1";
	var STATUS_STORAGE="2";
	var STATUS_REPAIR="5";
	var STATUS_LOST="4";
	var STATUS_STATUS_REQUESTED="11";
	var STATUS_TO_BE_SCRAPPED="12";
	var YES_VALUE="1";
	var NO_VALUE="2";
	var FLD_STATUS=iFldID_Status;
	var FLD_ALLOCATED_TO=iFldID_AllocatedToPerson;
	var FLD_REQUESTED_UNTIL=iFldID_RequestedUntil;
	var FLD_CURRENT_LOCATION=iFldID_CurrentLocation;
	var FLD_SEND_FOR_REPAIR=iFldID_SendForRepair;
	var FLD_STORAGE_LOCATION=iFldID_StorageLocation;
	var FLD_CHECK_IN=iFldID_CheckIn;
	var FLD_CHECK_IN_ASSET=iFldID_CheckInAsset;
	var FLD_CHECK_OUT_ASSET=iFldID_CheckOutAsset;
	var FLD_TO_BE_DELETED=iFldID_ToBeDeleted;
	
	function OnAfterLoadRec()
	{
		if(g_VWS)
		{
			var sStatus=m_oFldVals(FLD_STATUS).GetValue();
			
			SetHeader(sStatus);
			
			if(m_lngExchangeToID>0){
				if(m_oFldVals(FLD_CHECK_IN_ASSET)){		
					m_oFldVals(FLD_CHECK_IN_ASSET).SetValue(m_strExchangeFrom);
					m_oFldVals(FLD_CHECK_IN_ASSET).HideElement(false, null, true, FLD_CHECK_IN_ASSET, g_VWS.LoadDataMgr().GetDataHTMLDocumentObject());
				}
				if(m_oFldVals(FLD_CHECK_OUT_ASSET)){		
					m_oFldVals(FLD_CHECK_OUT_ASSET).SetValue(m_strExchangeTo);
					m_oFldVals(FLD_CHECK_OUT_ASSET).HideElement(false, null, true, FLD_CHECK_OUT_ASSET, g_VWS.LoadDataMgr().GetDataHTMLDocumentObject());
				}
			}else{
				if(m_oFldVals(FLD_CHECK_IN_ASSET)){		
					m_oFldVals(FLD_CHECK_IN_ASSET).HideElement(true, null, true, FLD_CHECK_IN_ASSET, g_VWS.LoadDataMgr().GetDataHTMLDocumentObject());
				}			
				if(m_oFldVals(FLD_CHECK_OUT_ASSET)){		
					m_oFldVals(FLD_CHECK_OUT_ASSET).HideElement(true, null, true, FLD_CHECK_OUT_ASSET, g_VWS.LoadDataMgr().GetDataHTMLDocumentObject());
				}
			}
			
			if(sStatus==STATUS_ASSIGNED || sStatus==STATUS_LOST || sStatus==STATUS_STATUS_REQUESTED) //Assigned, Lost, Status Requested
			{
				if(m_lngExchangeToID>0){
					SetSaveButtonText("BUTTON_EXCHANGE", "TOOLTIP_EXCHANGE");				
				}else{
					SetSaveButtonText("BUTTON_CHECKIN", "TOOLTIP_CHECKIN");					
				}
				
				if(m_oFldVals(FLD_CHECK_IN)){		
					m_oFldVals(FLD_CHECK_IN).SetValue(YES_VALUE);
					var objCheckInElem=m_oFldVals(FLD_CHECK_IN).GetElement();
					if(objCheckInElem){
						if(objCheckInElem.onchange){
							objCheckInElem.onchange();
						}
					}
				}
			}else //if (sStatus==STATUS_STORAGE)  // Storage
			 {
				SetSaveButtonText("BUTTON_CHECKOUT", "TOOLTIP_CHECKOUT");
				
				if(m_oFldVals(FLD_CHECK_IN)){		
					m_oFldVals(FLD_CHECK_IN).SetValue(NO_VALUE);
				}
			}
		}	
	}
	
	function saveBefore(objExtHdlrTemp)
	{
		var sStatus=m_oFldVals(FLD_STATUS).GetValue();
		var sSendForRepair=m_oFldVals(FLD_SEND_FOR_REPAIR).GetValue();
		var USER_NONE="0";
		var sScrapAsset=m_oFldVals(FLD_TO_BE_DELETED).GetValue();
		var blnScrapAsset=false;
		
		if(sScrapAsset=="1"){
			var strMsg="This asset will be completely removed from Vizor.\r\n\r\nAre you sure you want to continue?";
			if(window.confirm(strMsg))
			{
				blnScrapAsset=true;
			}else{
				objExtHdlrTemp.SetCancelProcess(true);
			}				
		}
		
		if(sStatus==STATUS_ASSIGNED || sStatus==STATUS_LOST || sStatus==STATUS_STATUS_REQUESTED) //Assigned, Lost, Status Requested
		{
			// Check in 
			var blnContinue=true;
			
			if(m_lngExchangeToID>0){
				//copy the status, assigned to person and current location from the current record to the m_lngExchangeToID
				if(m_oCenMn){
					if(m_oCenMn.objRecord){
						var lngSrcID=m_oCenMn.objRecord.GetRecordId();
						var lngTgtID=m_lngExchangeToID;
						var strFields="865;11;" + FLD_CURRENT_LOCATION;
						var strURL="FLDS=" + g_MqRef.MqStr.MqEncodeURIComponent(strFields) + 
										"&SRC=" + lngSrcID + "&TGT=" + lngTgtID;
						var co = m_oCenMn.objRequest.Post(m_oCenMn.mstrCurrentLocation + "../ASP/SetVals.asp", strURL);
						
						if (co==lngTgtID){
							m_lngExchangeToID=0;
							m_strExchangeTo="";
							m_strExchangeFrom="";
						}else{
							g_MqRef.AlertBox.show(g_MqRef.RESX["TITLE_CANT_EXCHANGE"], g_MqRef.RESX["MSG_CANT_EXCHANGE"]);
							blnContinue=false;
						}				
					}
				}
			}
			
			if(blnContinue){
				// Set the owner to nothing
				if(m_oFldVals(FLD_ALLOCATED_TO)){		
					m_oFldVals(FLD_ALLOCATED_TO).SetValue(USER_NONE);
				}
				if(m_oFldVals(FLD_STATUS)){	
					if(sSendForRepair=="1"){
						//set status to in repair
						m_oFldVals(FLD_STATUS).SetValue(STATUS_REPAIR);
						
						//clear the checkbox so we don't save it in the asset
						if(m_oFldVals(FLD_SEND_FOR_REPAIR)){		
							m_oFldVals(FLD_SEND_FOR_REPAIR).SetValue("");
						}
					}else{
						if(blnScrapAsset){
							//set status to be scrapped
							m_oFldVals(FLD_STATUS).SetValue(STATUS_TO_BE_SCRAPPED);
						}else{
							m_oFldVals(FLD_STATUS).SetValue(STATUS_STORAGE);
						}
					}
				}
				//clear the requested until
				if(m_oFldVals(FLD_REQUESTED_UNTIL)){		
					m_oFldVals(FLD_REQUESTED_UNTIL).SetValue("");
				}
				//clear the current location or set to the storage location
				var sStorageLoc=m_oFldVals(FLD_STORAGE_LOCATION).GetValue();
				if(m_oFldVals(FLD_CURRENT_LOCATION)){		
					if(sStorageLoc!=""){
						m_oFldVals(FLD_CURRENT_LOCATION).SetValue(sStorageLoc);
					}else{
						m_oFldVals(FLD_CURRENT_LOCATION).SetValue("");
					}
				}
				//clear the storage location
				if(m_oFldVals(FLD_STORAGE_LOCATION)){		
					m_oFldVals(FLD_STORAGE_LOCATION).SetValue("");
				}
			}
		}
		else
		{
			// Check out
			// Ensure it is allocated to someone
			var sVal=m_oFldVals(FLD_ALLOCATED_TO).GetValue();
			
			if (sVal==USER_NONE || sVal=="")
			{
				alert(g_MqRef.RESX["MSG_NEED_PERSON_TO_ALLOCATE"]); 
				objExtHdlrTemp.SetCancelProcess(true);
				
			}
			else
			{
				m_oFldVals(FLD_STATUS).SetValue(STATUS_ASSIGNED);
				
			}
		}
		
		if(m_oFldVals(FLD_CHECK_IN)){		
			m_oFldVals(FLD_CHECK_IN).SetValue("");
		}
		
		if(m_oFldVals(FLD_CHECK_IN_ASSET)){		
			m_oFldVals(FLD_CHECK_IN_ASSET).SetValue("");
		}
		
		if(m_oFldVals(FLD_CHECK_OUT_ASSET)){		
			m_oFldVals(FLD_CHECK_OUT_ASSET).SetValue("");
		}
		
		return objExtHdlrTemp;
	}
	
	function saveAfter()
	{
		g_VWS.SummaryList().SLSearch().SetFocus(true);		
	}
	
	function cancelAfter()
	{
		m_lngExchangeToID=0;
		m_strExchangeTo="";
		m_strExchangeFrom="";
	}
	
	function setExchangeAsset(lngExchangeToID, strExchangeTo, strExchangeFrom)
	{
		m_lngExchangeToID=lngExchangeToID;
		m_strExchangeTo=strExchangeTo;
		m_strExchangeFrom=strExchangeFrom;
	}
	
	this.Name="MqCheckInOutExt ";
	this.OnAfterLoadRec=OnAfterLoadRec;
	this.saveBefore=saveBefore;
	this.saveAfter=saveAfter;
	this.cancelAfter=cancelAfter;
	this.setExchangeAsset=setExchangeAsset;
	
	function HideButton(strButtonName, blnVisible)
	{
		if(m_oCenMn){
			var oButton = m_oCenMn.document.getElementById(strButtonName);
			
			if(oButton){
				if(blnVisible){
					oButton.style.display = '';
					oButton.style.visibility = 'visible';
				}else{
					oButton.style.display = 'none';
					oButton.style.visibility = 'hidden';
				}
			}
		}
	}
	
	function SetSaveButtonText(strResCaption, strResTooltip)
	{
		var btnSave=g_VWS.CommandBar().GetElement("lnkActionOK");
		
		if(btnSave)
		{
			btnSave.innerText=g_MqRef.RESX[strResCaption];
			btnSave.title=g_MqRef.RESX[strResTooltip];
		}
						
	}
	
	function SetHeader(sStatus)
	{
		var strTitleRes="WIZARD_CHECKIN_CHECKOUT_ASSET_TITLE";
		var strDescRes="WIZARD_CHECKIN_CHECKOUT_ASSET_DESCRIPTION";
		
		if(m_oCenMn){
			HideButton("cmdEmailIssue", false);
			HideButton("cmdEmailConv", false);
			
			if(m_lngExchangeToID>0){
				HideButton("cmdHistory", false);
				strTitleRes="SCAN_EXCHANGE_ASSETS_TITLE";
				strDescRes="WIZARD_CHECKIN_CHECKOUT_ASSET_DESCRIPTION";
			}else{
				HideButton("cmdHistory", true);
							
				if(sStatus==STATUS_ASSIGNED || sStatus==STATUS_LOST || sStatus==STATUS_STATUS_REQUESTED){ //Assigned, Lost, Status Requested
					strTitleRes="WIZARD_CHECKIN_ASSET_TITLE";
					strDescRes="WIZARD_CHECKIN_CHECKOUT_ASSET_DESCRIPTION";
				}else{
					//if (sStatus==STATUS_STORAGE){  // Storage
					strTitleRes="WIZARD_CHECKOUT_ASSET_TITLE";
					strDescRes="WIZARD_CHECKIN_CHECKOUT_ASSET_DESCRIPTION";
				}
			}
				
			m_oCenMn.WIZARD_TITLE_EDIT=g_MqRef.MqStr.Format(g_MqRef.RESX[strTitleRes],"<ValOfField>30</ValOfField>");
			m_oCenMn.WIZARD_DESCRIPTION_EDIT=g_MqRef.MqStr.Format(g_MqRef.RESX[strDescRes], "<ValOfField>30</ValOfField>");

			oCenMn.objRecord.OnAfterLoad();
		}
	}
	WriteConsole("MqCheckInOutExt: Initializing the extension " + this.Name);		
}
